/*
 * Decompiled with CFR 0.152.
 */
package com.cobblemon.mod.common.pokedex.scanner;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.pokedex.scanner.ScannableEntity;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/cobblemon/mod/common/pokedex/scanner/PokemonScanner;", "", "<init>", "()V", "Lnet/minecraft/class_1297;", "castingEntity", "", "zoomLevel", "detectEntity", "(Lnet/minecraft/class_1297;I)Lnet/minecraft/class_1297;", "Lcom/cobblemon/mod/common/pokedex/scanner/ScannableEntity;", "findScannableEntity", "(Lnet/minecraft/class_1297;I)Lcom/cobblemon/mod/common/pokedex/scanner/ScannableEntity;", "targetEntity", "", "isEntityInRange", "(Lnet/minecraft/class_1297;Lnet/minecraft/class_1297;I)Z", "common"})
public final class PokemonScanner {
    @NotNull
    public static final PokemonScanner INSTANCE = new PokemonScanner();

    private PokemonScanner() {
    }

    @Nullable
    public final class_1297 detectEntity(@NotNull class_1297 castingEntity, int zoomLevel) {
        Intrinsics.checkNotNullParameter((Object)castingEntity, (String)"castingEntity");
        class_243 eyePos = castingEntity.method_5836(1.0f);
        class_243 lookVec = castingEntity.method_5828(1.0f);
        double maxDistance = Cobblemon.INSTANCE.getConfig().getMaxPokedexScanningDetectionRange() + (double)zoomLevel;
        double boundingBoxSize = 12.0 + (double)zoomLevel;
        class_1297 closestEntity = null;
        double closestDistance = maxDistance;
        class_238 boundingBox = new class_238(castingEntity.method_23317() - boundingBoxSize, castingEntity.method_23318() - boundingBoxSize, castingEntity.method_23321() - boundingBoxSize, castingEntity.method_23317() + boundingBoxSize, castingEntity.method_23318() + boundingBoxSize, castingEntity.method_23321() + boundingBoxSize);
        List entities = castingEntity.method_37908().method_8390(class_1297.class, boundingBox, arg_0 -> PokemonScanner.detectEntity$lambda$1(arg_0 -> PokemonScanner.detectEntity$lambda$0(castingEntity, arg_0), arg_0));
        for (class_1297 entity : entities) {
            boolean pathCollidesWithBlock;
            double maxSize;
            double minSize;
            double boxDepth;
            double boxHeight;
            class_238 entityBox;
            Intrinsics.checkNotNullExpressionValue((Object)entity.method_5829(), (String)"getBoundingBox(...)");
            double maxSizeScale = 1.0;
            double minSizeScale = 2.0;
            double steepCoefficient = 20.0;
            double boxWidth = entityBox.method_17939();
            double boxVolume = boxWidth * (boxHeight = entityBox.method_17940()) * (boxDepth = entityBox.method_17941());
            double normalizedSize = (boxVolume - (minSize = 0.2)) / RangesKt.coerceAtLeast((double)((maxSize = 3.0) - minSize), (double)0.01);
            double inflationFactor = maxSizeScale + (minSizeScale - maxSizeScale) * Math.exp(-steepCoefficient * normalizedSize);
            class_238 inflatedBox = entityBox.method_1009((inflationFactor - 1.0) * boxWidth / (double)2, (inflationFactor - 1.0) * boxHeight / (double)2, (inflationFactor - 1.0) * boxDepth / (double)2);
            Optional intersection = inflatedBox.method_992(eyePos, eyePos.method_1019(lookVec.method_1021(maxDistance)));
            if (!intersection.isPresent()) continue;
            double distanceToEntity = eyePos.method_1022((class_243)intersection.get());
            if (distanceToEntity < closestDistance) {
                closestEntity = entity;
                closestDistance = distanceToEntity;
            }
            if (closestEntity == null || !(pathCollidesWithBlock = castingEntity.method_37908().method_17742(new class_3959(eyePos, (class_243)intersection.get(), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, castingEntity)).method_17783() == class_239.class_240.field_1332)) continue;
            closestEntity = null;
        }
        return closestEntity;
    }

    @Nullable
    public final ScannableEntity findScannableEntity(@NotNull class_1297 castingEntity, int zoomLevel) {
        Intrinsics.checkNotNullParameter((Object)castingEntity, (String)"castingEntity");
        class_1297 targetedEntity = this.detectEntity(castingEntity, zoomLevel * 2);
        return targetedEntity instanceof ScannableEntity ? (ScannableEntity)targetedEntity : null;
    }

    public final boolean isEntityInRange(@NotNull class_1297 castingEntity, @NotNull class_1297 targetEntity, int zoomLevel) {
        Intrinsics.checkNotNullParameter((Object)castingEntity, (String)"castingEntity");
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        return targetEntity.method_19538().method_1022(castingEntity.method_19538()) <= Cobblemon.INSTANCE.getConfig().getMaxPokedexScanningDetectionRange() + (double)(zoomLevel * 2);
    }

    private static final boolean detectEntity$lambda$0(class_1297 $castingEntity, class_1297 it) {
        return it != $castingEntity;
    }

    private static final boolean detectEntity$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

